//
//  HHRGServiceFactory.h
//  ReverseGeocode
//
//  Created by Pierre Bernard on 7/20/10.
//  Copyright 2010-2015 Houdah Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "HHReverseGeocoder.h"


@interface HHRGServiceFactory : NSObject

@property (nonatomic, copy) NSString		*defaultServiceName;
@property (nonatomic, copy) NSDictionary	*services;

+ (void)registerServiceClass:(Class)implementationClass forServiceName:(NSString *)name;
+ (BOOL)hasServiceClassForServiceName:(NSString *)name;

+ (HHRGServiceFactory *)sharedServiceFactory;

- (Class)serviceClassWithPreferredName:(NSString *)preferredName serviceName:(NSString **)outServiceName;

- (BOOL)startReverseGeocoder:(HHReverseGeocoder *)reverseGeocoder;
- (BOOL)preFlightCheck:(NSDictionary *)options outError:(NSError **)preFlightError;

@end
